from sqlalchemy import Column, Integer, String, Boolean, ForeignKey
from sqlalchemy.orm import relationship
from database import Base

class User(Base):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    email = Column(String, unique=True)
    password = Column(String)
    credits = Column(Integer, default=100)
    api_key = Column(String, unique=True)

class ValidationLog(Base):
    __tablename__ = "validations"

    id = Column(Integer, primary_key=True)
    user_id = Column(Integer, ForeignKey("users.id"))
    input_data = Column(String)
    result = Column(String)
